--This has a creation function for the burning pig
require 'g_level'

lua_init_texture_animation("boar_run","data/images/characters/boar/", 7, MODE_LOOP, DIRECTION_FORWARD, 0.125, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)


function create_burning_pig(from,to,layer) --from_x,to_x,layer
    local speed = 700.0
    local dmg_start_script = "data/scripts/test/srt_start_damage_test.lua"
    local dmg_end_script = "data/scripts/test/srt_stop_damage_test.lua"
    local scale = 0.15

    local y_safe_height = 500.0

    lua:create_creature("creature", CPT_MOVING_CREATURE, "boar_run", "", "", "") -- name, type, stand_animation, run_animation, jump_up_animation, jump_down_animation
    lua:creature_speed("creature", CPT_MOVING_CREATURE, speed) -- name, type, speed
    lua:creature_shape("creature",CPT_MOVING_CREATURE,1024/2*scale,512/2*scale) --name, type
    lua:creature_color("creature", CPT_MOVING_CREATURE, 1.0, 1.0, 1.0, 1.0) --name, type , rgba
    lua:creature_translation("creature", CPT_MOVING_CREATURE, from, y_safe_height) -- set the player to it's right position

    local shape_scale = 0.4
    lua:create_shape("creature_rectangle",PSC_RECTANGLE,1024*scale*shape_scale,512*scale*shape_scale) -- name, type, width, height
    lua:create_trigger("creature_gate", TT_GATE, dmg_start_script,dmg_end_script,0.0,0.0) --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape("creature_gate", TT_GATE, "creature_rectangle") --name, type, shape_name
    lua:trigger_add_group_i_belong_to("creature_gate", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me("creature_gate", TT_GATE, "player") --name, type, group_name
    lua:creature_trigger("creature",CPT_MOVING_CREATURE,"creature_gate",g_level.next_id()) -- name, type, trigger_name

    lua:create_pathing_graph(false)         -- is_circular
    lua:add_pathing_graph_point(from,10.0);    --x,y
    lua:add_pathing_graph_point(to,10.0);
    lua:create_ai("creature","physicalmove")  -- creature, state name

    -- fire
    lua:create_sprite("prototype", ST_PARTICLE, "myParticle", 0.0, 0.0)  --the translation values can be anything. They must be there for integrity but they ain't used to anything.
    lua:sprite_shape("prototype", ST_PARTICLE, 10.0,10.0)
    lua:textured_sprite_tex_coords("prototype", ST_PARTICLE, 0.0, 0.0, 1.0, 1.0)
    lua:particle_start_color("prototype", 0.7, 0.4, 0.3, 0.9) -- name: rgba-colors
    lua:particle_end_color("prototype", 0.0, 0.0, 0.0, 0.0)

    lua:create_sprite("emitter", ST_EMITTER, "prototype", 0.0, 0.0) -- the translation values are on, the "texture" is the teztured particle inserted.
    lua:emitter_range("emitter", 0.75, 1.5, -5.0, 5.0, 25.0, 75.0)  --life min & max, angular_velocity min & max, linear_velocity min & max
    lua:emitter_scale("emitter", true, 1.0, 3.0, 2.0, 6.0)  -- variable_scale, begin_scale_range min & max, end_scale_range min & max
    lua:emitter_particle_amount("emitter", 55)  --
    lua:emitter_angle("emitter", 3.14) -- angle. (0-PI)

    -- quick and dirty
    lua:creature_emitter("creature", "emitter")
    lua:gameobject_remove_from_temp_list( "prototype" )

    g_level.upload("creature",layer)
    lua:gameobject_remove_from_temp_list( "creature" )

    g_level.upload("emitter",layer)
    lua:gameobject_remove_from_temp_list( "emitter" )
end